//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2015 BY HOLTEK SEMICONDUCTOR INC
//  File Name : MasterII.c
// Description: IOIICD
//     Note   : ROM SIZE 230 RAM ̾ڱoeBUFPjp@,̤p15ByteHW
//___________________________________________________________________
//___________________________________________________________________
#include "Master_IIC.h"


volatile unsigned char gu8v_IIC_RData[IIC_RXDATALENGHT],gu8v_IIC_WData[IIC_TXDATALENGHT];

/********************************************************************
Function: IIC Start
INPUT	:
OUTPUT	:
NOTE	: IIC Start: when CLK is high,SDA change from high to low
********************************************************************/
void fun_IIC_Start()
{
    IIC_SCL_OUTPUTMODE();
    IIC_SDA_OUTPUTMODE();
    IIC_SDA_OUTPUTHIHG();
    IIC_SCL_OUTPUTHIGH();
	GCC_DELAY(IIC_SPEED);
    IIC_SDA_OUTPUTLOW();
	GCC_DELAY(IIC_SPEED);
    IIC_SCL_OUTPUTLOW();
}
/********************************************************************
Function: IIC Stop
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_IIC_Stop()
{
    IIC_SDA_OUTPUTLOW();
    IIC_SDA_OUTPUTMODE();
	GCC_DELAY(IIC_SPEED);
    IIC_SCL_OUTPUTHIGH();
	GCC_DELAY(IIC_SPEED);
    IIC_SDA_OUTPUTHIHG();
	GCC_DELAY(IIC_SPEED);
    IIC_SDA_INPUTMODE();
}
/********************************************************************
Function: IIC oeACK~򱵦
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_IIC_Ack()
{
    IIC_SDA_OUTPUTMODE();
    IIC_SDA_OUTPUTLOW();
    GCC_DELAY(IIC_SPEED);
    IIC_SCL_OUTPUTHIGH();
    GCC_DELAY(IIC_SPEED);
    IIC_SCL_OUTPUTLOW();
    GCC_DELAY(IIC_SPEED);
    IIC_SDA_OUTPUTHIHG();
    GCC_DELAY(IIC_SPEED);
}

//**********************************
//NoAck(1) signal
//**********************************
void fun_IIC_NoAck(void)
{
	IIC_SDA_OUTPUTMODE();
    IIC_SDA_OUTPUTHIHG();
    GCC_DELAY(IIC_SPEED);
    IIC_SCL_OUTPUTHIGH();
    GCC_DELAY(IIC_SPEED);
    IIC_SCL_OUTPUTLOW();
    GCC_DELAY(IIC_SPEED);
}
/********************************************************************
Function: IIC Wait ACK
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_IIC_WaitACK()
{
    IIC_SDA_INPUTMODE();
    GCC_DELAY(IIC_SPEED);
    IIC_SCL_OUTPUTHIGH();
	unsigned char i=0;
	while(IIC_SDA_ISHIGH() && ( i < 250 ))
	{
	 	i++;
	}
    IIC_SCL_OUTPUTLOW();
    GCC_DELAY(IIC_SPEED);
}
/********************************************************************
Function: IIC Write Byte
INPUT	: WData
OUTPUT	:
NOTE	:
********************************************************************/
void fun_IIC_WByte(unsigned char WData)
{
    IIC_SDA_OUTPUTMODE();
 	unsigned char i;
 	for( i=0; i<8; i++)
 	{
        IIC_SCL_OUTPUTLOW();
 		GCC_DELAY(IIC_SPEED);
 		if( WData & 0x80 )
 		{
            IIC_SDA_OUTPUTHIHG();
 		}
 		else
 		{
            IIC_SDA_OUTPUTLOW();
 		}
 		GCC_DELAY(IIC_SPEED);
        IIC_SCL_OUTPUTHIGH();
 		GCC_DELAY(IIC_SPEED);
 		WData <<= 1;
 	}
     IIC_SCL_OUTPUTLOW();
     IIC_SDA_INPUTMODE();
}
/********************************************************************
Function: IIC Read Byte
INPUT	:
OUTPUT	: RData
NOTE	:
********************************************************************/
unsigned char fun_IIC_RByte(unsigned char Ack)
{
    IIC_SDA_INPUTMODE();
    IIC_SCL_OUTPUTLOW();
	unsigned char i,RData = 0;
 	GCC_DELAY(IIC_SPEED);
    IIC_SCL_OUTPUTHIGH();
	for(i=0; i<8; i++)
	{
        IIC_SCL_OUTPUTHIGH()
		GCC_DELAY(IIC_SPEED);
		RData = (RData<<1)|IIC_SDA;
        IIC_SCL_OUTPUTLOW();
		GCC_DELAY(IIC_SPEED);
	}
	if (Ack){
		fun_IIC_Ack();
	}
	else{
		fun_IIC_NoAck();
	}
	return RData;
}
/********************************************************************
Function: gƾڨq
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_IICWrite_Data(unsigned char Slave_Address,unsigned char WriteLength)
{
	fun_IIC_Start();
	fun_IIC_WByte(Slave_Address);
	fun_IIC_WaitACK();
	fun_IIC_WByte(gu8v_IIC_WData[0]);
	fun_IIC_WaitACK();
	unsigned char i;
	for (i = 1; i <= WriteLength; i++)
	{
		fun_IIC_WByte(gu8v_IIC_WData[i]);
		fun_IIC_WaitACK();
	}
	fun_IIC_Stop();
}
/********************************************************************
Function: gƾڨq
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_IICRead_Data(unsigned char Slave_Address,unsigned char ReadLength)
{
	fun_IIC_Start();
	fun_IIC_WByte(Slave_Address);
	fun_IIC_WaitACK();
	fun_IIC_WByte(gu8v_IIC_RData[0]);
	fun_IIC_WaitACK();
	fun_IIC_Start();
	fun_IIC_WByte(Slave_Address+1);
	fun_IIC_WaitACK();
	GCC_DELAY(IIC_SPEED);
	unsigned char i;
	for (i = 1; i < ReadLength; i++)
	{
		gu8v_IIC_RData[i] = fun_IIC_RByte(1);
	}
	GCC_DELAY(IIC_SPEED);
	gu8v_IIC_RData[ReadLength] = fun_IIC_RByte(0);
	fun_IIC_Stop();
}